﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using System.Diagnostics;

namespace KeyConfig
{
	public class PadMonitor
	{
		#region # Fields #

		GamePad _gamePad;
		int? last = null;

		#endregion

		/// <summary>
		/// PadMonitor のインスタンスを作成します。
		/// </summary>
		public PadMonitor(GamePad gamePad)
		{
			if (gamePad == null) throw new ArgumentNullException("gamePad");

			_gamePad = gamePad;
		}

		public void Check()
		{
			var list = _gamePad.GetPressed();

			if (list.Count == 1)
			{
				var value = list[0];

				if (last != value)
				{
					OnPressed(new DataEventArgs<int>(value));
					last = value;
				}
			}
			else if (list.Count == 0)
			{
				last = null;
			}
		}

		#region # Events #
		/// <summary>
		/// ゲームパッドのボタンが押された時に発生します。
		/// </summary>
		public event EventHandler<DataEventArgs<int>> Pressed;

		/// <summary>
		/// Pressed イベントを発生させます。
		/// </summary>
		protected virtual void OnPressed(DataEventArgs<int> e)
		{
			if (Pressed != null)
			{
				Pressed(this, e);
			}
		}
		#endregion
	}
}