﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using KeyConfig.Config;
using KeyConfig.Map;

namespace KeyConfig
{
	public class KeyEditor : EditorBase
	{
		#region # Fields #

		ShootingConfig _shootConfig;
		KeyNameMap _nameMap;
		List<TextBox> textBoxList = new List<TextBox>();

		#endregion

		//----------// //----------// //----------// //----------//
		//
		//	Methods
		//
		//----------// //----------// //----------// //----------//

		internal void InitializeEditor(ShootingConfig config, KeyNameMap nameMap, int labelWidth, int textWidth, int labelHeight)
		{
			if (config == null) throw new ArgumentNullException("config");
			if (nameMap == null) throw new ArgumentNullException("map");

			_shootConfig = config;
			_nameMap = nameMap;

			var lblTitle = new Label()
			{
				AutoSize = true,
				Text = "キーボード用のキーコンフィグ"
			};

			this.Controls.Add(lblTitle);

			var kt = new ListLabel() { Top = 24 };
			kt.UpdateTitle(GetTitles(), 88);

			this.Controls.Add(kt);

			for (int i = 0; i < config.Keys.Count; i++)
			{
				var textBox = new TextBox()
				{
					ReadOnly = true,
					Multiline = true,
					AcceptsTab = true,
					Left = labelWidth + 8,
					Width = textWidth,
					Top = labelHeight * (i + 1),
					Text = ((Keys)config.Keys[i]).ToString()
				};

				textBox.KeyDown += new KeyEventHandler(txtKey_KeyDown);

				this.Controls.Add(textBox);

				textBoxList.Add(textBox);
			}

			this.Width = textBoxList[textBoxList.Count - 1].Right;
			this.Height = labelHeight * (config.Keys.Count + 1);
		}

		private void txtKey_KeyDown(object sender, KeyEventArgs e)
		{
			var box = sender as TextBox;
			int index = textBoxList.IndexOf(box);

			box.Text = e.KeyCode.ToString();
			_shootConfig.Keys[index] = e.KeyValue;

			if (index < (textBoxList.Count - 1))
			{
				textBoxList[index + 1].Focus();
			}
			else
			{
				OnProceedFocus(EventArgs.Empty);
			}
			Edited = true;
			e.Handled = true;
		}

		private IEnumerable<string> GetTitles()
		{
			for (int i = 0; i < _shootConfig.Keys.Count; i++)
			{
				yield return _nameMap.Parse(i);
			}
		}

		//----------// //----------// //----------// //----------//
		//
		//	Properties
		//
		//----------// //----------// //----------// //----------//

		public Control FocusTarget
		{
			get
			{
				return textBoxList[0];
			}
		}
	}
}