﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Reflection;

namespace KeyConfig
{
	public static class KeyConfigPaths
	{
		/// <summary>
		/// ShootingBuilder の ini ファイルのパスを取得します。
		/// </summary>
		public static string ShootingIni { get; private set; }
	
		public static string Dictionary { get; private set; }

		public static string Debug { get; private set; }
	
		static KeyConfigPaths()
		{
			string dir = Path.GetDirectoryName(Assembly.GetEntryAssembly().Location);

			ShootingIni = Path.Combine(dir, "CONFIG.INI");
			Dictionary = Path.Combine(dir, "CONFIG.DAT");
			Debug = Path.Combine(dir, "KEYCONFIG.LOG.TXT");
		}
	}
}