﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace KeyConfig
{
	/// <summary>
	/// GamePad.dll へのマーシャリングを宣言するクラスです。
	/// </summary>
	public static class GamePadApi
	{
		/// <summary>
		/// 処理の成功を示す値です。
		/// </summary>
		public const int DirectInputOK = 0;

		/// <summary>
		/// DirectInput オブジェクトを作成します。
		/// </summary>
		[DllImport("gamepad.dll")]
		public static extern int CreateDirectInput();

		/// <summary>
		/// DirectInputDevice オブジェクトを作成します。
		/// </summary>
		[DllImport("gamepad.dll")]
		public static extern int CreateGamePad(IntPtr hwnd);

		/// <summary>
		/// ゲームパッドの検出に成功したかどうかを判断します。
		/// </summary>
		[DllImport("gamepad.dll")]
		public static extern int IsGamePadFound(ref bool deviceFound);

		/// <summary>
		/// ゲームパッドの確保に成功したかどうかを判断します。
		/// </summary>
		[DllImport("gamepad.dll")]
		public static extern int IsGamePadAcquired(ref bool deviceAcquired);

		/// <summary>
		/// ゲームパッドで押されたキーを取得します。
		/// </summary>
		[DllImport("gamepad.dll")]
		public static extern int GetPressedKeys(ref GamePadBuffer buffer, int cbBuffer);

		/// <summary>
		/// DirectInput オブジェクトを破棄します。
		/// </summary>
		[DllImport("gamepad.dll")]
		public static extern void DeleteDirectInput();

		/// <summary>
		/// DirectInputDevice オブジェクトを破棄します。
		/// </summary>		
		[DllImport("gamepad.dll")]
		public static extern void DeleteGamePad();
	}

	[StructLayout(LayoutKind.Sequential)]
	public struct GamePadBuffer
	{
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
		public byte[] Buffer;
	}
}