﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;
using KeyConfig.Config;
using System.Diagnostics;

namespace KeyConfig.Config
{
	/// <summary>
	/// ShootingBuilder のキー設定を書き込むクラスです。
	/// </summary>
	public static class ShootingConfigWriter
	{
		public static void WriteTo(ShootingConfig config, string path)
		{
			if (config == null) throw new ArgumentNullException("config");
			if (path == null) throw new ArgumentNullException("path");

			for (int i = 0; i < config.Keys.Count; i++)
			{
				IniEditor.WriteInteger(IniSections.Keys, String.Format("BUTTON{0:D}", i), config.Keys[i], path);
			}
			for (int i = 0; i < config.Pads.Count; i++)
			{
				IniEditor.WriteInteger(IniSections.Pads, String.Format("BUTTON{0:D}", i), config.Pads[i], path);
			}
			IniEditor.WriteBoolean(IniSections.Screen, IniKeys.FullScreen, config.FullScreen, path);
			IniEditor.WriteBoolean(IniSections.Screen, IniKeys.SyncTimer, config.SyncTimer, path);
			IniEditor.WriteInteger(IniSections.Screen, IniKeys.SkipFrame, config.SkipFrame, path);
		}
	}
}