﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace KeyConfig.Config
{
	/// <summary>
	/// ShootingBuilder のキー設定を読み込むクラスです。
	/// </summary>
	public static class ShootingConfigReader
	{
		public static ShootingConfig ReadFrom(string path)
		{
			var config = new ShootingConfig();

			for (int i = 0; i < config.Keys.Count; i++)
			{
				config.Keys[i] = IniEditor.ReadInteger(IniSections.Keys, String.Format("BUTTON{0:D}", i), (int)Keys.None, path);
			}
			for (int i = 0; i < config.Pads.Count; i++)
			{
				config.Pads[i] = IniEditor.ReadInteger(IniSections.Pads, String.Format("BUTTON{0:D}", i), (int)Keys.None, path);
			}
			config.FullScreen = IniEditor.ReadBoolean(IniSections.Screen, IniKeys.FullScreen, config.FullScreen, path);
			config.SyncTimer = IniEditor.ReadBoolean(IniSections.Screen, IniKeys.SyncTimer, config.SyncTimer, path);
			config.SkipFrame = IniEditor.ReadInteger(IniSections.Screen, IniKeys.SkipFrame, config.SkipFrame, path);
			return config;
		}
	}
}