﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;

namespace KeyConfig.Config
{
	public class ShootingConfig
	{
		#region # Fields #

		Collection<int> _keys = new Collection<int>(new List<int>(new int[10]));
		Collection<int> _pads = new Collection<int>(new List<int>(new int[10]));
		bool _fullScreen = true;
		bool _syncTimer = false;
		int _skipFrame = 0;

		/// <summary>
		/// 割り当てられたキーの一覧を取得します。
		/// </summary>
		public Collection<int> Keys
		{
			get { return _keys; }
		}

		/// <summary>
		/// 割り当てられたパッドのボタン一覧を取得します。
		/// </summary>
		public Collection<int> Pads
		{
			get { return _pads; }
		}

		/// <summary>
		/// ゲームをフルスクリーンで表示するかどうかを取得または設定します。
		/// </summary>
		public bool FullScreen
		{
			get { return _fullScreen; }
			set { _fullScreen = value; }
		}

		/// <summary>
		/// タイマー同期を行うかどうかを取得または設定します。
		/// </summary>
		public bool SyncTimer
		{
			get { return _syncTimer; }
			set { _syncTimer = value; }
		}

		/// <summary>
		/// 描画フレームのスキップ数を取得または設定します。
		/// </summary>
		public int SkipFrame
		{
			get { return _skipFrame; }
			set
			{
				if (value >= 4)
				{
					throw new ArgumentOutOfRangeException();
				}
				_skipFrame = value;
			}
		}
		#endregion

		/// <summary>
		/// ShootingConfig のインスタンスを作成します。
		/// </summary>
		public ShootingConfig() { }
	}
}