﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;

namespace KeyConfig.Map
{
	public class KeyNameMap
	{
		Dictionary<string, string> table;
	
		public KeyNameMap(Dictionary<string, string> table)
		{
			if (table == null) throw new ArgumentNullException("table");

			this.table = table;
		}

		public string Parse(int index)
		{
			string name = String.Format("BUTTON{0:D}", index);
			if (table.ContainsKey(name))
			{
				return table[name];
			}
			else
			{
				return name;
			}
		}
	}
}