﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KeyConfig
{
	public class ListLabel : UserControl
	{
		public void UpdateTitle(IEnumerable<string> titles, int width)
		{
			const int labelHeight = 24;

			int i = 0;
			int height = 0;

			foreach (var title in titles)
			{
				// ラベルの作成
				var label = new Label()
				{
					TextAlign = ContentAlignment.BottomLeft,
					Top = i * labelHeight,
					Height = 16,
					Width = width,
					Text = title
				};

				//
				this.Controls.Add(label);

				height = label.Bottom;

				//
				i++;
			}

			this.Width = width;
			this.Height = height;
		}
	}
}