﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace KeyConfig
{
	/// <summary>
	/// DirectX を通して、ゲームパッドの処理を受け付けるクラスです。
	/// </summary>
	public class GamePad : IDisposable
	{
		#region # Fields #

		bool _disposed = false;
		bool _directInputCreated = false;

		/// <summary>
		/// DirectX の作成に成功したかどうかを示します。
		/// </summary>
		[Obsolete]
		public bool DirectXCreated
		{
			get { return false; }
		}

		/// <summary>
		/// DirectInput の作成に成功したかどうかを示します。
		/// </summary>
		public bool DirectInputCreated
		{
			get { return _directInputCreated; }
		}

		/// <summary>
		/// ジョイスティックを検出したかどうかを示します。
		/// </summary>
		public bool DeviceFound
		{
			get
			{
				bool deviceFound = false;
				GamePadApi.IsGamePadFound(ref deviceFound);
				return deviceFound;
			}
		}

		/// <summary>
		/// ジョイスティックの制御権を確保したかどうかを示します。
		/// </summary>
		public bool DeviceAcquired
		{
			get
			{
				bool deviceAcquired = false;
				GamePadApi.IsGamePadAcquired(ref deviceAcquired);
				return deviceAcquired;
			}
		}
		#endregion

		//----------// //----------// //----------// //----------// //----------// //----------//

		#region # Constructor, Destructor #
		/// <summary>
		/// JoyStick のインスタンスを作成します。
		/// </summary>
		/// <param name="hwnd">DirectX をアタッチするウィンドウのハンドル。</param>
		public GamePad(IntPtr hwnd)
		{
			CreateDirectInput();
			CreateGamePad(hwnd);
		}

		~GamePad()
		{
			Dispose(true);
		}

		/// <summary>
		/// オブジェクトを破棄します。
		/// </summary>
		public void Dispose()
		{
			Dispose(false);
		}

		private void CreateDirectInput()
		{
			try
			{
				int result = GamePadApi.CreateDirectInput();
				if (result == GamePadApi.DirectInputOK)
				{
					_directInputCreated = true;
				}
				else
				{
					throw new Exception(String.Format("HResult Error: {0:D}", result));
				}
			}
			catch (Exception ex)
			{
				throw new Exception("DirectInput の作成に失敗しました。", ex);
			}
		}

		private void CreateGamePad(IntPtr hwnd)
		{
			int result = GamePadApi.CreateGamePad(hwnd);
			if (result == GamePadApi.DirectInputOK)
			{
				// 正常フロー
			}
			else
			{
				throw new Exception(String.Format("HResult Error: {0:D}", result));
			}
		}

		private void Dispose(bool finalizing)
		{
			try
			{
				if (!_disposed)
				{
					_disposed = true;
					if (!finalizing)
					{
						GC.SuppressFinalize(this);
					}

					// アンマネージ DLL のリソースを解放する
					GamePadApi.DeleteGamePad();
					GamePadApi.DeleteDirectInput();
				}
			}
			catch (Exception ex)
			{
				Program.WriteLog(ex.ToString());
			}
		}
		#endregion

		//----------// //----------// //----------// //----------// //----------// //----------//

		internal List<int> GetPressed()
		{
//			if (DeviceAcquired)
//			{
				GamePadBuffer buffer = new GamePadBuffer();
				buffer.Buffer = new byte[32];
				GamePadApi.GetPressedKeys(ref buffer, 32);

				// 取得したキーの一覧を作成する
				List<int> keys = new List<int>();
				for (int i = 0; i < buffer.Buffer.Length; i++)
				{
					if (buffer.Buffer[i] != 0)
					{
						keys.Add(i);
					}
				}
				return keys;
//			}
//			else
//			{
//				return new List<int>();
//			}
		}
	}
}