﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace KeyConfig
{
	public class EditorBase : UserControl
	{
		//----------// //----------// //----------// //----------//
		//
		//	Events
		//
		//----------// //----------// //----------// //----------//

		internal event EventHandler EditedChanged;

		private void OnEditedChanged(EventArgs e)
		{
			if (EditedChanged != null)
			{
				EditedChanged(this, e);
			}
		}

		internal event EventHandler ProceedFocus;

		protected virtual void OnProceedFocus(EventArgs e)
		{
			if (ProceedFocus != null)
			{
				ProceedFocus(this, e);
			}
		}

		//----------// //----------// //----------// //----------//
		//
		//	Fields
		//
		//----------// //----------// //----------// //----------//

		bool edited = false;

		//----------// //----------// //----------// //----------//
		//
		//	Properties
		//
		//----------// //----------// //----------// //----------//

		internal bool Edited
		{
			get { return edited; }
			set
			{
				if (edited != value)
				{
					edited = value;
					OnEditedChanged(EventArgs.Empty);
				}
			}
		}
	}
}