﻿using System;
using System.Collections.Generic;
using System.Text;

namespace KeyConfig.Config
{
	internal class SyncTimer
	{
		//----------// //----------// //----------// //----------//
		//
		//	Constructor
		//
		//----------// //----------// //----------// //----------//

		private SyncTimer(bool value)
		{
			this.value = value;
		}

		//----------// //----------// //----------// //----------//
		//
		//	Fields
		//
		//----------// //----------// //----------// //----------//

		bool value = true;

		//----------// //----------// //----------// //----------//
		//
		//	Property
		//
		//----------// //----------// //----------// //----------//

		internal string Expression
		{
			get
			{
				return value ? "1" : "0";
			}
		}

		//----------// //----------// //----------// //----------//
		//
		//	static
		//
		//----------// //----------// //----------// //----------//

		internal static readonly SyncTimer On = new SyncTimer(true);

		internal static readonly SyncTimer Off = new SyncTimer(false);

		//----------// //----------// //----------// //----------//
		//
		//	operator
		//
		//----------// //----------// //----------// //----------//

		public static implicit operator bool(SyncTimer sync)
		{
			return sync.value;
		}

		public static implicit operator SyncTimer(bool value)
		{
			return value ? On : Off;
		}
	}
}