#include <string>
#include <dinput.h>
#include <windows.h>
#include "Program.h"

#pragma comment(lib, "dinput8.lib")
#pragma comment(lib, "dxguid.lib")
#pragma comment(lib, "user32.lib")

//----------// //----------// //----------// //----------// //----------// //----------//

// Fields
LPDIRECTINPUT _directInput = NULL;			// IDirectInput
LPDIRECTINPUTDEVICE _inputDevice = NULL;	// IDirectInputDevice
HWND _hwnd = NULL;
bool _deviceFound = false;

// Signatures
BOOL CALLBACK DIEnumJoyStickCallback(LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef);

//----------// //----------// //----------// //----------// //----------// //----------//

/**
 * DLL ̃Gg|CgłB
 */
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason,  LPVOID lpvReserved)
{
	return TRUE;
}

/**
 * DirectInput ̃CX^X쐬܂B
 */
HRESULT __stdcall CreateDirectInput()
{
	return DirectInput8Create(GetModuleHandle(NULL), DIRECTINPUT_VERSION, IID_IDirectInput8, (void**)&_directInput, NULL);
}

HRESULT __stdcall CreateGamePad(HWND hwnd)
{
	// asserts
	if (_directInput == NULL)
	{
		return E_FAIL;
	}

	// cache handle
	_hwnd = hwnd;

	// enum devices
	return _directInput->EnumDevices(DI8DEVTYPE_JOYSTICK, DIEnumJoyStickCallback, NULL, DIEDFL_ATTACHEDONLY);
}

BOOL CALLBACK DIEnumJoyStickCallback(LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef)
{
	// asserts
	if (_hwnd == NULL)
	{
		return DIENUM_STOP;
	}

	// main
	_deviceFound = true;
	HRESULT ret = _directInput->CreateDevice(lpddi->guidInstance, &_inputDevice, NULL);
	if (ret == DI_OK)
	{
		ret = _inputDevice->SetDataFormat(&c_dfDIJoystick);
		if (ret == DI_OK)
		{
			ret = _inputDevice->SetCooperativeLevel(_hwnd, DISCL_NONEXCLUSIVE | DISCL_BACKGROUND | DISCL_NOWINKEY);
			if (ret == DI_OK)
			{
				ret = _inputDevice->Acquire();
				if (ret == DI_OK)
				{
					return DIENUM_STOP;
				}
			}
		}
		_inputDevice->Release();
	}

	// strong guarantee ̎
	_inputDevice = NULL;

	// 񋓂p
	return DIENUM_CONTINUE;
}

HRESULT __stdcall IsGamePadFound(bool* deviceFound)
{
	printf("IsGamePadFound\r\n");
	*deviceFound = _deviceFound;
	return S_OK;
}

HRESULT __stdcall IsGamePadAcquired(bool* deviceAcquired)
{
	*deviceAcquired = _inputDevice != NULL;
	return S_OK;
}

void DumpBuffer(BYTE* buffer)
{
	for (int i = 0; i < 32; i++)
	{
		if (i == 16)
		{
			printf("\r\n");
		}
		printf("%2x ", buffer[i]);
	}
	printf("\r\n\r\n");
}

HRESULT __stdcall GetPressedKeys(KeyBuffer* buffer, int cbBuffer)
{
	if (_inputDevice == NULL)
	{
		// input device ݂Ȃꍇ
		// obt@[NA
		for (int i = 0; i < min(32, cbBuffer); i++)
		{
			buffer->Buffer[i] = 0;
		}
		return S_OK;
	}

	DIJOYSTATE state;
	HRESULT hr = _inputDevice->GetDeviceState(sizeof(state), &state);

	for (int i = 0; i < min(32, cbBuffer); i++)
	{
		buffer->Buffer[i] = (state.rgbButtons[i] & 0x80) != 0;
	}
	return S_OK;
}

/**
 * DirectInput ̃CX^Xj܂B
 */
void __stdcall DeleteDirectInput()
{
	if (_directInput != NULL)
	{
		_directInput->Release();
		_directInput = NULL;
	}
}

/**
 * DirectInputDevice ̃CX^Xj܂B
 */
void __stdcall DeleteGamePad()
{
	if (_inputDevice != NULL)
	{
		_inputDevice->Release();
		_inputDevice = NULL;
	}
}